//Step Responses of a II order system for zeta=0.1(underdamped), zeta=1(critically damped) & zeta=1.5(overdamped)
t=0:0.0000001:0.0002;
zeta=[0.5 1 1.5];
cv=[1 2 3];
s=%s;
for n=1:3    
num = 10^10;
den = s^2 + 2*zeta(n)*100000*s  +10^10; //wn=100k rad/sec
P = syslin('c',num,den);
Ps=csim('step',t,P);
plot2d(t,Ps,style=cv(n));
end;
xgrid;
xtitle(['Step Responses of a II order system for zeta=0.1(underdamped), zeta=1(critically damped) & zeta=1.5(overdamped)'],'Time', 'Amplitude' );
legends(['zeta=0.5';'zeta=1';'zeta=1.5'],[1,2,3],opt=4);
